package gov.va.genisis2.dao;

import java.util.List;

import gov.va.genisis2.exceptions.GenisisDAOException;
import gov.va.genisis2.model.CommentType;
import gov.va.genisis2.model.RequestType;
import gov.va.genisis2.model.Source;


public interface ILookUpDao {
	public int getStatusId(String statusDescription) throws GenisisDAOException;

	public RequestType getRequestType(int id) throws GenisisDAOException;

	public Source getSource(int id) throws GenisisDAOException;

	public List<Source> getDataSources() throws GenisisDAOException;

	public List<RequestType> getRequestTypes() throws GenisisDAOException;
	
	public CommentType getCommentType(int id) throws GenisisDAOException;
}
